IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Banco_Roela_AR_TX') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Banco_Roela_AR_TX
END
GO

CREATE FUNCTION [dbo].[CF_Banco_Roela_AR_TX](@pId_Trans INT, @pImporte DECIMAL(12,2), @pId_Tar_Lote INT, @pPeriodo DATETIME) 
RETURNS CHAR(280)
AS
BEGIN
/*Variable de Retorno*/
DECLARE @Retorno			CHAR(280)
/*FIN Variable de Retorno*/

/*Variables del Archivo*/
DECLARE @aCod_Registro			CHAR(1)		/*Codigo de Registro. Valor fijo: 5. Indica que este renglon forma parte del detalle.*/
DECLARE @aNroReferencia			CHAR(19)	/*Los 19 digitos se forman de la siguiente manera: 1)Los primeros nueve digitos son para identificar a los titulares de las obligaciones. Si utiliza el codigo debarras de SIRO, se completa la primera posicion con cero y las 8 restantes con el "identificador de usuario" del diseño de registro de codigo de barra SIRO). No puede utilizarse aqui un numero de comprobante. 2) Las ultimas 10 posiciones son el "identificador de cuenta" otorgado por Banco Roela (presente en el diseño de registro del Codigo de Barras SIRO)*/
DECLARE @aId_Factura			CHAR(20)	/*Debe completarse de la siguiente manera: 1) Las primeras 15 posiciones se completan con datos de la factura 2) La posicion 16 para identificar el concepto a facturar (si no se va a utilizar, completar con cero) 3) Los cuatro digitos restantes para identificar el mes y el año de facturacion con el formato MMAA. Por ejemplo si el Concepto 1 es "deuda" y el 2 es "intereses", si se quiere informar la deuda de agosto de 2014 este campo se completa con: XXXXXXXXXXXXXXX10814; y si se quiere informar el interes de ese mismo periodo, se completa con XXXXXXXXXXXXXXX20814. En caso que el ente trabaja con un solo concepto y no necesita discriminarlos, informara: XXXXXXXXXXXXXXX00814*/
DECLARE @aId_Moneda				CHAR(1)		/*Codigo de moneda de los importes informados. Valor fijo: 0 (Pesos).*/
DECLARE @aFecha_PriVenc			CHAR(8)		/*Fecha del 1er vencimiento de la factura Formato: AAAAMMDD*/
DECLARE @aImporte_PriVenc		CHAR(11)	/*Importe de la factura para el 1er vencimiento. Formato: 9 enteros, 2 decimales, sin separadores*/
DECLARE @aFecha_SegVenc			CHAR(8)		/*Fecha del 2do vencimiento de la factura Formato: AAAAMMDD*/
DECLARE @aImporte_SegVenc		CHAR(11)	/*Importe de la factura para el 2do vencimiento. Formato: 9 enteros, 2 decimales, sin separadores*/
DECLARE @aFecha_TerVenc			CHAR(8)		/*Fecha del 3er vencimiento de la factura Formato: AAAAMMDD*/
DECLARE @aImporte_TerVenc		CHAR(11)	/*Importe de la factura para el 3er vencimiento. Formato: 9 enteros, 2 decimales, sin separadores*/
DECLARE @aFiller1				CHAR(19)	/*Campo para uso futuro. Valor fijo: ceros.*/
DECLARE @aNro_Referencia_Ant	CHAR(19)	/*Repetir el valor informado en el campo "Nro. Referencia"*/
DECLARE @aMensajeTicket			CHAR(40)	/*Datos a informar en el ticket de pago. Utilizar de la siguiente manera: 1) Utilizar las primeras 15 posiciones para informar el Ente al cual se esta efectuando el pago, abreviando el nombre de modo que el pagador pueda identificar inequivocamente el Ente. 2) Utilizar las 25 posiciones restantes para informacion secundaria, como el concepto que se esta pagando y/o el periodo. Completar solo con letras mayusculas (sin acentos, ni "ñ") y numeros. No admite caracteres especiales (puntos, comas, parentesis, etc.).*/
DECLARE @aMensajePantalla		CHAR(15)	/*Datos a informar en la pantalla de seleccion de la factura a pagar. Utilizar las primeras 15 posiciones del campo "Mensaje en Ticket" para informar el Ente al cual se esta efectuando el pago, abreviando el nombre de modo que el pagador pueda identificar inequivocamente el Ente. Completar solo con letras mayusculas (sin acentos, ni "ñ") y numeros. No admite caracteres especiales (puntos, comas, parentesis, etc.).*/
DECLARE @aCodBarra				CHAR(60)	/*Completar con espacios.*/
DECLARE @aFiller2				CHAR(29)	/*Completar con ceros.*/
/*FIN Variables del Archivo*/

/*Variables Locales*/
DECLARE @Id_Tarjeta						VARCHAR(10)
DECLARE @Fecha_Presentacion				DATETIME
DECLARE @Fecha_1_Vto					DATETIME
DECLARE @Fecha_2_Vto					DATETIME
DECLARE @Fecha_3_Vto					DATETIME
DECLARE @Porc_Recargo_1_Vto				DECIMAL(12,5)
DECLARE @Porc_Recargo_2_Vto				DECIMAL(12,5)
DECLARE @Porc_Recargo_3_Vto				DECIMAL(12,5)
DECLARE @Comercio_Nro					VARCHAR(50)
DECLARE @Id_Cliente						INT
DECLARE @Id_Contrato					INT
DECLARE @Comprobante_Nro				INT
DECLARE @Fecha_Cbte						DATETIME
DECLARE @Id_Cliente_Externo				VARCHAR(14)
DECLARE @Id_Cliente_Ref					INT
DECLARE @Doc_Nro						BIGINT
DECLARE @Tipo_Persona					CHAR(1)
DECLARE @Porc_Recargo					DECIMAL(12,5)	
DECLARE @Id_Tipo_Cbte					VARCHAR(4)
DECLARE @Descripcion_Corta				VARCHAR(11)
DECLARE @Descripcion_Larga				VARCHAR(36)
DECLARE @Id_Cliente_Externo_Tit			VARCHAR(14)
DECLARE @Item_1							SMALLINT
DECLARE @Id_Cond_Pago_Item				SMALLINT
/*FIN Variables Locales*/

-------------------------------------------------------------------------------------------------------------------------------------------------------------------

/*Seteo Variables Locales*/
SELECT	
@Id_Tarjeta				= ISNULL(Id_Tarjeta, ''),
@Fecha_Presentacion		= ISNULL(Fecha_Presentacion, '19000101'),
@Fecha_1_Vto			= ISNULL(Fecha_1_Vto, '19000101'),
@Fecha_2_Vto			= ISNULL(Fecha_2_Vto, '19000101'),
@Fecha_3_Vto			= ISNULL(Fecha_3_Vto, '19000101')
FROM Val_Tarjetas_Lotes
WHERE
Id_Tar_Lote = @pId_Tar_Lote

SELECT
@Comercio_Nro			= LTRIM(RTRIM(ISNULL(Comercio_Nro, '')))
FROM Valores_Tarjetas_Cred
WHERE
ISNULL(Id_Tarjeta, '') = @Id_Tarjeta

SELECT	
@Id_Cliente		= ISNULL(Id_Cliente, 0),
@Fecha_Cbte		= ISNULL(Fecha, '19000101'),
@Id_Contrato	= ISNULL(Id_Contrato, 0),
@Comprobante_Nro= ISNULL(Comprobante_Nro, 0),
@Id_Tipo_Cbte	= ISNULL(Id_Tipo_Cbte, '')
FROM Cbtes 
WHERE
Id_Trans = @pId_Trans

SELECT
@Item_1			= MIN(Item)
FROM Cbtes_Items
WHERE
Id_Trans = @pId_Trans

SELECT
@Id_Cond_Pago_Item = ISNULL(Id_Cond_Pago, 0)
FROM Cbtes_Items
WHERE
Id_Trans = @pId_Trans
AND Item = @Item_1

SET @Porc_Recargo_1_Vto = ISNULL(	(SELECT 
									ISNULL(Porc_Bonif, 0)
									FROM Cbtes_Cond_Pago_Items 
									WHERE 
									Id_Cond_Pago = @Id_Cond_Pago_Item 
									AND Plazo_Desde <= DATEPART(DAY, @Fecha_1_Vto)
									AND Plazo_Bonif >= DATEPART(DAY, @Fecha_1_Vto))
								, 0)

SET @Porc_Recargo_1_Vto = (@Porc_Recargo_1_Vto / 100) + 1

SET @Porc_Recargo_2_Vto = ISNULL(	(SELECT 
									ISNULL(Porc_Bonif, 0)
									FROM Cbtes_Cond_Pago_Items 
									WHERE 
									Id_Cond_Pago = @Id_Cond_Pago_Item 
									AND Plazo_Desde <= DATEPART(DAY, @Fecha_2_Vto)
									AND Plazo_Bonif >= DATEPART(DAY, @Fecha_2_Vto))
								, 0)

SET @Porc_Recargo_2_Vto = (@Porc_Recargo_2_Vto / 100) + 1

SET @Porc_Recargo_3_Vto = ISNULL(	(SELECT 
									ISNULL(Porc_Bonif, 0)
									FROM Cbtes_Cond_Pago_Items 
									WHERE 
									Id_Cond_Pago = @Id_Cond_Pago_Item 
									AND Plazo_Desde <= DATEPART(DAY, @Fecha_3_Vto)
									AND Plazo_Bonif >= DATEPART(DAY, @Fecha_3_Vto))
								, 0)

SET @Porc_Recargo_3_Vto = (@Porc_Recargo_3_Vto / 100) + 1

SELECT 
@Id_Cliente_Externo		= ISNULL(Id_Cliente_Externo, Id_Cliente),
@Id_Cliente_Ref			= ISNULL(Id_Cliente_Ref, 0),
@Doc_Nro				= ISNULL(Doc_Nro, 0),
@Tipo_Persona			= ISNULL(Tipo_Persona, 'F')
FROM Clientes 
WHERE 
Id_Cliente = @Id_Cliente

SELECT 
@Id_Cliente_Externo_Tit		= ISNULL(Id_Cliente_Externo, Id_Cliente)
FROM Clientes 
WHERE 
Id_Cliente = @Id_Cliente_Ref

IF(@Porc_Recargo = 0)
BEGIN
	SET @Porc_Recargo = 1
END
ELSE
BEGIN
	SET @Porc_Recargo = (@Porc_Recargo / 100) + 1
END

-------------------------------------------------------------------------------------------------------------------------------------------------------------------

IF(@Tipo_Persona = 'I'/*Inmueble*/)
BEGIN
	IF(dbo.CF_IsNumeric(@Id_Cliente_Externo_Tit) = 1)
	BEGIN
		SET @Id_Cliente_Externo = CONVERT(VARCHAR(14), @Id_Cliente_Ref)
	END
	ELSE
	BEGIN
		SET @Id_Cliente_Externo = @Id_Cliente_Externo_Tit
	END
END
ELSE
BEGIN
	IF(dbo.CF_IsNumeric(@Id_Cliente_Externo) = 1)
	BEGIN
		SET @Id_Cliente_Externo = @Id_Cliente_Externo
	END
	ELSE
	BEGIN
		SET @Id_Cliente_Externo = CONVERT(VARCHAR(14), @Id_Cliente)
	END
END

-------------------------------------------------------------------------------------------------------------------------------------------------------------------

IF(@Tipo_Persona = 'I'/*Inmueble*/)
BEGIN
	SET @Descripcion_Corta = 'EXP '
	SET @Descripcion_Larga = 'EXPENSAS '
END
ELSE
BEGIN
	IF(@Id_Tipo_Cbte = 'CUP')
	BEGIN
		SET @Descripcion_Corta = 'C SOC '
		SET @Descripcion_Larga = 'CUOTA SOCIAL '
	END
	ELSE
	BEGIN
		SET @Descripcion_Corta = 'ACT C SOC '
		SET @Descripcion_Larga = 'CUOTA SOCIAL ACTIVIDADES '
	END
END

-------------------------------------------------------------------------------------------------------------------------------------------------------------------



-------------------------------------------------------------------------------------------------------------------------------------------------------------------

/*Seteo variables del Archivo*/
SET @aCod_Registro		= '5'

SET @aNroReferencia		= '0' + RIGHT('00000000' + @Id_Cliente_Externo, 8) + RIGHT('0000000000' + @Comercio_Nro, 10)

SET @aId_Factura		= RIGHT('000000000000000' + CAST(@pId_Trans AS VARCHAR), 15) + '4' + RIGHT('00' + CAST(DATEPART(MONTH, @Fecha_Cbte) AS VARCHAR), 2) + SUBSTRING(RIGHT('0000' + CAST(DATEPART(YEAR, @Fecha_Cbte) AS VARCHAR), 4), 3, 2)
                 
SET @aId_Moneda			= '0'

SET @aFecha_PriVenc		= RIGHT('0000' + CAST(DATEPART(YEAR, @Fecha_1_Vto) AS VARCHAR), 4) + RIGHT('00' + CAST(DATEPART(MONTH, @Fecha_1_Vto) AS VARCHAR), 2) + RIGHT('00' + CAST(DATEPART(DAY, @Fecha_1_Vto) AS VARCHAR), 2)

SET @aImporte_PriVenc	= (SELECT RIGHT('00000000000' + CAST(CAST(@pImporte * @Porc_Recargo_1_Vto * 100 AS INT) AS VARCHAR), 11))

SET @aFecha_SegVenc		= RIGHT('0000' + CAST(DATEPART(YEAR, @Fecha_2_Vto) AS VARCHAR), 4) + RIGHT('00' + CAST(DATEPART(MONTH, @Fecha_2_Vto) AS VARCHAR), 2) + RIGHT('00' + CAST(DATEPART(DAY, @Fecha_2_Vto) AS VARCHAR), 2)

SET @aImporte_SegVenc	= (SELECT RIGHT('00000000000' + CAST(CAST(@pImporte * @Porc_Recargo_2_Vto * 100 AS INT) AS VARCHAR), 11))

SET @aFecha_TerVenc		= RIGHT('0000' + CAST(DATEPART(YEAR, @Fecha_3_Vto) AS VARCHAR), 4) + RIGHT('00' + CAST(DATEPART(MONTH, @Fecha_3_Vto) AS VARCHAR), 2) + RIGHT('00' + CAST(DATEPART(DAY, @Fecha_3_Vto) AS VARCHAR), 2)

SET @aImporte_TerVenc	= (SELECT RIGHT('00000000000' + CAST(CAST(@pImporte * @Porc_Recargo_3_Vto * 100 AS INT) AS VARCHAR), 11))

SET @aFiller1			= '0000000000000000000'

SET @aNro_Referencia_Ant = @aNroReferencia

		 
SET @aMensajeTicket		= @Descripcion_Larga + RIGHT('00' + CAST(DATEPART(MONTH, @pPeriodo) AS VARCHAR), 2) + SUBSTRING(RIGHT('0000' + CAST(DATEPART(YEAR, @pPeriodo) AS VARCHAR), 4), 3, 2)

SET @aMensajePantalla	= @Descripcion_Corta + RIGHT('00' + CAST(DATEPART(MONTH, @pPeriodo) AS VARCHAR), 2) + SUBSTRING(RIGHT('0000' + CAST(DATEPART(YEAR, @pPeriodo) AS VARCHAR), 4), 3, 2)
                
SET @aCodBarra			= '                                                            '

SET @aFiller2			= '00000000000000000000000000000'

-------------------------------------------------------------------------------------------------------------------------------------------------------------------
                    
SET @Retorno =	@aCod_Registro		+ 
				@aNroReferencia		+ 
				@aId_Factura		+ 
				@aId_Moneda			+
				@aFecha_PriVenc		+
				@aImporte_PriVenc	+
				@aFecha_SegVenc		+
				@aImporte_SegVenc	+
				@aFecha_TerVenc		+
				@aImporte_TerVenc	+
				@aFiller1			+
				@aNro_Referencia_Ant +
				@aMensajeTicket		+
				@aMensajePantalla	+
				@aCodBarra			+
				@aFiller2

-------------------------------------------------------------------------------------------------------------------------------------------------------------------

RETURN ISNULL(@Retorno, '                                                                                                                                                                                                                                                                                        ')
END
